/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs.actionLogging;

import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.actionLogging.Command;
import Game_Engine.Engine.Objs.obj_glidable;
import Game_Engine.GUI.Components.small.gui_label;
import Game_Engine.GUI.SpriteLoader;
import java.io.File;
import util.FileIO;

public class obj_cursor
extends obj_glidable {
    boolean mouse_pressed = false;
    int x_last;
    int y_last;
    final int PRESS = 1;
    final int UNPRESS = -1;
    private UBA<Command> commands;
    private int current_command_index = 0;
    private boolean should_loop = false;
    private boolean global = false;

    public obj_cursor(double x_in, double y_in) {
        super(x_in, y_in);
        this.sprite = SpriteLoader.cursor_symbol;
        this.setInterpolationTime(30);
        this.x_last = (int)this.getX();
        this.y_last = (int)this.getY();
        this.setCollidable(false);
        this.setDepth(-2147483647);
    }

    public void keyPSpecial(int key) {
        if (this.global) {
            this.setTimeTillDone(0);
            return;
        }
        this.myContainer.killProxyCursor();
    }

    @Override
    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        super.update();
        this.handleCommands();
        int x = (int)this.getX();
        int y = (int)this.getY();
        boolean changed = x != this.x_last || y != this.y_last;
        this.x_last = x;
        this.y_last = y;
        if (!changed) {
            return;
        }
        if (this.global && this.myContainer.proxy_cursor != null) {
            return;
        }
        if (this.mouse_pressed) {
            this.myContainer.mouseD(x, y);
            this.myContainer.global_mouseD(x, y);
        }
        this.myContainer.mouseM(x, y);
        this.myContainer.global_mouseM(x, y);
    }

    protected void handleCommands() {
        int x = (int)this.getX();
        int y = (int)this.getY();
        if (this.interpolator.done()) {
            if (this.current_command_index >= this.commands.size()) {
                if (!this.should_loop) {
                    this.die();
                    if (this.global) {
                        gui_label finis = new gui_label(this.myContainer.getW() / 2, this.myContainer.getH() / 2, this.myContainer.getW() / 2, this.myContainer.getH() / 2);
                        finis.setText("Done");
                        finis.xSub(finis.getW() / 2);
                        finis.ySub(finis.getH() / 2);
                        finis.setDepth(-2147483647);
                        this.myContainer.obj_create((Obj)finis);
                        return;
                    }
                    this.myContainer.killProxyCursor();
                    return;
                }
                this.glide(this.x_start, this.y_start);
                this.current_command_index = 0;
                return;
            }
            Command current_command = this.commands.get(this.current_command_index);
            int val = current_command.getCommand();
            switch (val) {
                case 0: {
                    if (this.global && this.myContainer.proxy_cursor != null) break;
                    this.myContainer.mouseP(x, y);
                    this.myContainer.global_mouseP();
                    this.mouse_pressed = true;
                    break;
                }
                case 1: {
                    if (this.global && this.myContainer.proxy_cursor != null) {
                        this.mouse_pressed = false;
                        break;
                    }
                    this.myContainer.mouseR(x, y);
                    this.myContainer.global_mouseR();
                    this.mouse_pressed = false;
                    break;
                }
                case 3: {
                    if (this.global && this.myContainer.proxy_cursor != null) {
                        this.myContainer.proxy_cursor.keyPSpecial(current_command.getKey());
                        break;
                    }
                    this.myContainer.keyP(current_command.getKey());
                    break;
                }
                case 4: {
                    this.myContainer.keyR(current_command.getKey());
                    break;
                }
                case 2: {
                    int x_new = current_command.getDestX();
                    int y_new = current_command.getDestY();
                    int delay = current_command.getKey();
                    this.setInterpolationTime(delay);
                    if (Math.abs(x - x_new) < 2 && Math.abs(y - y_new) < 2) break;
                    this.glide(x_new, y_new);
                    break;
                }
                default: {
                    throw new Error("COMMAND : " + val + " not supported");
                }
            }
            ++this.current_command_index;
        }
    }

    public void program(String fileChild) {
        File file = FileIO.parseFile(fileChild);
        UBA<Command> program = Command.computeProgramFromFile(file);
        this.commands = program;
    }

    public void program(UBA<Command> program) {
        this.commands = program;
    }

    public void loop() {
        this.should_loop = true;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void makeGlobal() {
        this.global = true;
        this.setDepth(Integer.MIN_VALUE);
    }
}

